// CMainDict.cp
// CMainDict.h
// ----------------------------------------------------------------------------------
// The main dictionary class.
//
// This dictionary is regular disk based dictionary.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original
//		Clark Goble			08/14/94
//			Checked it over and made a few modifications as part of the
//			C++ conversion.
//		Clark Goble			08/24/94
//			Made it a subclass of CDict
// ----------------------------------------------------------------------------------


#ifndef _CMAINDICT_
#define _CMAINDICT_

#include "UData.h"
#include "CComp.h"
#include "UIndex.h"
#include "UHead.h"
#include "UBloom.h"
#include "CDict.h"

// tells where we are in the dictionary
typedef struct {
	char *Word; // the current word
	char *LastWord; // the last word we have read.
	unsigned short  CurrentNibble; // the nibble into the buffer we are currently reading
	unsigned short  CurrentPage; // the page into the file we are currently reading
	short  EndOfPage; // flags whether we have reached the end of a page
	UInt8 *DictPage;
} CURSOR;


class CMainDict : public CDict, public CCompress, public UExtended {
public:
	CMainDict(long NumBuffers, FioParam * theFile);	// constructor
	virtual ~CMainDict();	// destruct was CloseDictionary

	short		First(char *Word);
	void	Current(char *Word);
	short		Next(char *Word);
	short		Find(char *Word);
	short		Check(char *Word);

	// friend MakeDictT;
protected:
	Uio 		*DictFile;		// the physical data file
	UBloom 		*FrequentWords;	// list of frequent words
	UIndex 		*Index;			// index of dictionary - tells page word is on
	UDataFile 	*Buffers;		// buffered file
	CURSOR 		location;		// current location in dictionary
	//CCompress	*Compresser;	// Decompresser
	
	long 	FWFilterSize;		// frequent word bloom filter size
	long 	FWFilterOffset;		// offset in file to the bloom filter
	
	long 	NumPages;    		// The number of pages the compressed word list takes up.
	long 	PageSize;   		// The size of each of the various pages 
	long 	PageOffset;  		// Offset for the begining page of the compressed word list
	long 	IndexOffset; 		// Offset for the index for the various pages 
	long 	Version;     		// The current version of the index structure 

}; // CMainDict

#endif

